unit CHILDWIN;

interface

uses Windows, Sysutils, Classes, Forms, Controls, StdCtrls, FileCtrl,
  ComCtrls, ExtCtrls, Menus, ImgList, tout, ShellApi, Dialogs, ActnList,
  images;

type
  TMDIChild = class(TForm)
    dossiers: TTreeView;
    contenu_repertoire: TListView;
    Splitter1: TSplitter;
    Panel1: TPanel;
    label_secteurs: TLabel;
    label_faces: TLabel;
    label_piste_debut: TLabel;
    label_piste_fin: TLabel;
    label_taille: TLabel;
    nb_secteurs: TLabel;
    nb_faces: TLabel;
    piste_debut: TLabel;
    piste_fin: TLabel;
    taille: TLabel;
    label_libre: TLabel;
    libre: TLabel;
    icones: TImageList;
    Popupmenu_fichiers: TPopupMenu;
    voir: TMenuItem;
    enregistrer: TMenuItem;
    label_nb_fichiers_selectionnes: TLabel;
    label_taille_fichiers_selectionnes: TLabel;
    nb_fichiers_selectionnes: TLabel;
    taille_fichiers_selectionnes: TLabel;
    Supprimer1: TMenuItem;
    Popupmenu_repertoires: TPopupMenu;
    MenuItem1: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure dossiersChange(Sender: TObject; Node: TTreeNode);
    procedure contenu_repertoireMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure voirClick(Sender: TObject);
    procedure enregistrerClick(Sender: TObject);
    procedure contenu_repertoireKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure dossiersDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure dossiersDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure contenu_repertoireSelectItem(Sender: TObject;
      Item: TListItem; Selected: Boolean);
    procedure contenu_repertoireDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure contenu_repertoireDragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure dossiersKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure dossiersMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
    procedure lire_contenu_img(pointeur:integer; niveau_rep: integer; image:p_imagedisk);
    procedure creation_arborescence(item_parent:ttreenode; num_parent:integer);

  public
    { Public declarations }
    disquette:imagedisk;

    procedure nouveau_repertoire;
    procedure effacer_fichier;
    procedure effacer_repertoire;
    procedure sauvegarde_modifications;
    procedure actualisation_informations;
    procedure actualisation_contenu_repertoire;
    procedure actualisation_repertoires;
    procedure transfert_de_fichiers(sender,source:tobject);
  end;

implementation

{$R *.dfm}

uses main, config, traduction, explorateur;

var
    erreur_fat:boolean;


//-------------------------------------------------------------------------------------------
//Actualisation des informations sur l'image disque en bas de la fentre
procedure TMDIChild.actualisation_informations;
begin
    libre.caption:=inttostr(comptage_clusters(1,@disquette)*disquette.taille_cluster)+textes_disquette[0];
    nb_faces.caption:=inttostr(disquette.nbfaces);
    nb_secteurs.caption:=inttostr(disquette.nbsecteurs);
    piste_debut.caption:=inttostr(disquette.piste_depart);
    piste_fin.caption:=inttostr(disquette.piste_fin);
    taille.caption:=inttostr(disquette.taille)+textes_disquette[0];
end;

//-------------------------------------------------------------------------------------------
//Fermeture de la fentre
procedure TMDIChild.FormClose(Sender: TObject; var Action: TCloseAction);
var
    choix:word;

begin
    if disquette.modif=true then
    begin
        choix:=MessageDlg(
            textes_disquette[1]+extraire_nom_fichier(self.Caption)+textes_disquette[2]
            +#13#10+#13#10+textes_disquette[3]
            , mtConfirmation, [mbYes, mbNo], 0);

        case choix of
            mrYes:
                sauvegarde_modifications;
            mrNo:
        end;
    end;

    setlength(disquette.donnees,0);
    setlength(disquette.contenu_img,0);
    ecrit_ini_childwin(self);
    Action := caFree;
end;

//-------------------------------------------------------------------------------------------
//Sauvegarde des modifications de l'image disque
procedure TMDIChild.sauvegarde_modifications;
var
    type_image:string;

begin
    type_image:=lowercase(extraire_type_fichier(self.Caption));

    if (type_image<>'st') and (type_image<>'msa') then
    begin
        MessageDlg(textes_disquette[4]+type_image, mtInformation, [mbOk], 0);

        MSA_Converter.selecfichier.title:=textes_disquette[5];
        MSA_Converter.selecfichier.Filter:=textes_disquette[6];
        MSA_Converter.selecfichier.FileName:=extraire_debut_nom_fichier(self.Caption)+'.st';
        MSA_Converter.selecfichier.Options:=[ofHideReadOnly,ofPathMustExist,ofHideReadOnly];

        if MSA_Converter.selecfichier.Execute then
        begin
            disquette.nomfichier:=MSA_Converter.selecfichier.FileName;
            if fileexists(disquette.nomfichier) then deletefile(disquette.nomfichier);
            sauve_image_disque(@disquette);
        end;
    end
    else if type_image='msa' then
    begin
        conversion_st_vers_msa(@disquette,@fichier_temp,disquette.piste_depart,disquette.piste_fin);
        fichier_temp.nomfichier:=self.Caption;
        sauve_image_disque(@fichier_temp);
    end
    else if type_image='st' then sauve_image_disque(@disquette);

    disquette.modif:=false;
end;

//-------------------------------------------------------------------------------------------
//Demande de mis  jour du contenu
//sur changement de slection de rpertoire
procedure TMDIChild.dossiersChange(Sender: TObject; Node: TTreeNode);
begin
    contenu_repertoire.Selected:=nil;
    actualisation_contenu_repertoire;
end;

//-------------------------------------------------------------------------------------------
//Affichage du menu Popup  l'emplacement de la souris dans la listview
procedure TMDIChild.contenu_repertoireMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
    if Button = mbRight then
        if contenu_repertoire.GetItemAt(x, y)<> nil then
            Popupmenu_fichiers.Popup(mouse.cursorpos.x,mouse.cursorpos.y);
end;

//-------------------------------------------------------------------------------------------
//Enregistre le fichier slectionn dans la listview dans le rpertoire de travail
//et l'ouvre avec le notepad
procedure TMDIChild.voirClick(Sender: TObject);
var
    fichier:tfilestream;
    taille:integer;
    choix:integer;
    nomfichier:string;
    buffer_fichier:array of byte;
    type_fichier:string;

begin
    if contenu_repertoire.Items.Count>0 then
    begin
        nomfichier:=rep_travail+entree_fat(contenu_repertoire.Selected.data^).nom;
        taille:=entree_fat(contenu_repertoire.Selected.data^).taille;
        setlength(buffer_fichier,taille);
        extraire_fichier(entree_fat(contenu_repertoire.Selected.data^).numero-1,@disquette,buffer_fichier);
        type_fichier:=uppercase(extraire_type_fichier(nomfichier));
        //Si le fichier n'est pas une image, on l'ouvre avec notepad
        if (type_fichier<>'NEO') and
            (type_fichier<>'PI1') and
            (type_fichier<>'PI2') and
            (type_fichier<>'PI3') and
            (type_fichier<>'PC1') and
            (type_fichier<>'PC2') and
            (type_fichier<>'PC3') and
            (type_fichier<>'SPU') and
            (type_fichier<>'SPC') and
            (type_fichier<>'SPS') and
            (type_fichier<>'ART') and
            (type_fichier<>'TNY') and
            (type_fichier<>'TN1') and
            (type_fichier<>'TN2') and
            (type_fichier<>'TN3') and
            (type_fichier<>'DOO') and
            (type_fichier<>'MUR') then
        begin
            fichier:=TFileStream.Create(nomfichier,fmCreate);
            fichier.Seek(0,soFromBeginning);
            fichier.Write(buffer_fichier[0],taille);
            fichier.free;

            ShellExecute(0, nil, 'notepad.exe', pchar(nomfichier), nil, sw_normal);
            if fileexists(nomfichier) then
            begin
                choix:=MessageDlg(textes_disquette[11]+#13#10+#13#10+nomfichier,
                                 mtConfirmation, [mbYes, mbNo], 0);
                case choix of
                    mrYes:
                         deletefile(nomfichier);
                    mrNo:
                end;
            end;
        end
        //Si le fichier est une image au format conn, on l'affiche
        else begin
            visu_images.Show;
            try
                affiche_image(type_fichier,nomfichier,buffer_fichier);
            except
                showmessage(textes_disquette[12]);
            end;
        end;
        setlength(buffer_fichier,0);
    end;
end;

//-------------------------------------------------------------------------------------------
//Enregistre le fichier slectionn dans la listview dans le rpertoire de travail
procedure TMDIChild.enregistrerClick(Sender: TObject);
var
    fichier:tfilestream;
    taille:integer;
    num_fichier:integer;
    nomfichier:string;
    compteur:integer;
    nombre_fichiers:integer;
    repertoire:string;
    buffer_fichier:array of byte;

begin
    if contenu_repertoire.Focused=true then
    begin
        if SelectDirectory(textes_disquette[35],'',repertoire)=true then
        begin
            if repertoire[length(repertoire)]<>'\' then repertoire:=repertoire+'\';
            num_fichier:=contenu_repertoire.Selected.index;
            nombre_fichiers:=contenu_repertoire.selcount;
            compteur:=0;
            repeat
                inc(compteur);
                if compteur>1 then
                begin
                    repeat
                        inc(num_fichier);
                    until contenu_repertoire.Items[num_fichier].Selected=true
                end;

                nomfichier:=repertoire+entree_fat(contenu_repertoire.Items[num_fichier].data^).nom;
                taille:=entree_fat(contenu_repertoire.Items[num_fichier].data^).taille;
                setlength(buffer_fichier,taille);
                extraire_fichier(entree_fat(contenu_repertoire.Items[num_fichier].Data^).numero-1,@disquette,buffer_fichier);
                fichier:= TFileStream.Create(nomfichier,fmCreate);
                fichier.Seek(0,soFromBeginning);
                fichier.Write(buffer_fichier[0],taille);
                fichier.free;
                setlength(buffer_fichier,0);
            until compteur>=nombre_fichiers;
        end;
    end
    else beep;
    if fenetre_explorateur<>nil then fenetre_explorateur.actualisation_contenu_repertoire;
end;

//-------------------------------------------------------------------------------------------
//Suppression de fichiers par la touche 'Suppr'
//Slection de tous le fichiers du browser par appui sur 'Ctrl + a'
procedure TMDIChild.contenu_repertoireKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
    if (key=ord('A')) and (ssCtrl in shift) then contenu_repertoire.selectall;
    if key=VK_DELETE then effacer_fichier;
end;

//-------------------------------------------------------------------------------------------
//Cration de la fentre et chargement de l'image disque correspondante
procedure TMDIChild.FormCreate(Sender: TObject);
var
    nom_fichier:string;

begin
    erreur_fat:=false;
    traduction_textes_disquette(self);
    lit_ini_childwin(self);
    nom_fichier:=MSA_Converter.selecfichier.filename;
    caption := nom_fichier;
    disquette.nomfichier:=nom_fichier;
    try
        charge_image_disque(@disquette);
        lire_infos_image_disque(@disquette,true);

        if disquette.fichier_ok=true then
        begin
            if disquette.sorte<>'st' then
            begin
                if disquette.sorte='msa' then conversion_msa_vers_st(@disquette,@fichier_temp)
                else if disquette.sorte='dim' then conversion_dim_vers_st(@disquette,@fichier_temp)
                else if disquette.sorte='stt' then conversion_stt_vers_st(@disquette,@fichier_temp);
                setlength(disquette.donnees,length(fichier_temp.donnees));
                copymemory(@disquette.donnees[0],@fichier_temp.donnees[0],length(fichier_temp.donnees));
                disquette.nomfichier:='msatemp.st';
                setlength(fichier_temp.donnees,0);
                lire_infos_image_disque(@disquette,true);
            end;
            if (not erreur_fat) then actualisation_repertoires;
        end;
    except
        MessageDlg(textes_disquette[7]+nom_fichier, mtInformation, [mbOk], 0);
        disquette.fichier_ok:=false;
    end;
end;

//-------------------------------------------------------------------------------------------
//Actualisation de l'arborescence des rpertoires
procedure TMDIChild.actualisation_repertoires;
var
    item_parent:ttreenode;

begin
    disquette.nb_entrees_fat:=0;
    lire_contenu_img(disquette.adr_debut_rep,0,@disquette);
    dossiers.Items.BeginUpdate;
    dossiers.Items.Clear;
    contenu_repertoire.Items.Clear;
    item_parent:=dossiers.Items.addchild(nil,extraire_nom_fichier(self.Caption));
    dossiers.Items.GetFirstNode.ImageIndex:=1;
    dossiers.Items.GetFirstNode.SelectedIndex:=1;

    creation_arborescence(item_parent,0);

    if disquette.nomimage<>'' then dossiers.Items.GetFirstNode.Text:=disquette.nomimage;
    dossiers.Items.EndUpdate;
    dossiers.Items.AlphaSort(true);
    dossiers.items[0].selected:=true;
    dossiers.Selected.Expand(false);

    actualisation_contenu_repertoire;
    actualisation_informations;
end;

//-------------------------------------------------------------------------------------------
//Cration arborescence des rpertoires
procedure TMDIChild.creation_arborescence(item_parent:ttreenode;num_parent:integer);
var
    compteur:integer;
    item:ttreenode;

begin
    if length(disquette.contenu_img)>0 then
        for compteur:=0 to disquette.nb_entrees_fat-1 do
            if (disquette.contenu_img[compteur].sorte='dir')
                and (disquette.contenu_img[compteur].parent=num_parent) then
             begin
                item:=dossiers.Items.addchildobject(item_parent,disquette.contenu_img[compteur].nom,@(disquette.contenu_img[compteur]));
                item.ImageIndex:=0;
                item.SelectedIndex:=0;
                creation_arborescence(item,disquette.contenu_img[compteur].numero);
             end;
end;

//-------------------------------------------------------------------------------------------
//Affichage du contenu du rpertoire slectionn
procedure TMDIChild.actualisation_contenu_repertoire;
var
    rep_parent:integer;
    compteur:integer;
    item:tlistitem;
    attributs_entree:string;
    data:byte;

begin
    contenu_repertoire.Items.BeginUpdate;
    contenu_repertoire.Items.clear;
    if length(disquette.contenu_img)>0 then
    begin
        if dossiers.Selected.level=0 then rep_parent:=0
            else rep_parent:=entree_fat(dossiers.Selected.data^).numero;
        for compteur:=0 to disquette.nb_entrees_fat-1 do
            if (disquette.contenu_img[compteur].parent=rep_parent)
                and (disquette.contenu_img[compteur].sorte='file') then
            begin
                item:=contenu_repertoire.Items.Add;
                item.caption:=disquette.contenu_img[compteur].nom;
                item.SubItems.Add(inttostr(disquette.contenu_img[compteur].taille));

                attributs_entree:='';
                data:=disquette.contenu_img[compteur].attributs;
                if (data and 1)=1 then attributs_entree:='R';  //Fichier en lecture seule
                if (data and 2)=2 then attributs_entree:=attributs_entree+'H';  //Fichier cach
                if (data and 4)=4 then attributs_entree:=attributs_entree+'S';  //Fichier systme
                if (data and 32)=32 then attributs_entree:=attributs_entree+'A';  //Fichier archive
                item.SubItems.Add(attributs_entree);

                item.SubItems.Add(disquette.contenu_img[compteur].heure);
                item.SubItems.Add(disquette.contenu_img[compteur].date);
                item.Data:=@disquette.contenu_img[compteur];
            end;
        contenu_repertoire.AlphaSort;
    end;
    contenu_repertoire.Items.EndUpdate;
end;

//-------------------------------------------------------------------------------------------
//Actualisation des informations sur les fichiers slectionns en bas de la fentre
procedure TMDIChild.contenu_repertoireSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
var
    num_fichier:integer;
    taille_fichiers_choisis:integer;
    nb_fichiers_choisis:integer;

begin
    nb_fichiers_choisis:=contenu_repertoire.SelCount;
    taille_fichiers_choisis:=0;
    if nb_fichiers_choisis>0 then
        for num_fichier:=contenu_repertoire.selected.Index to contenu_repertoire.items.count-1 do
            if contenu_repertoire.Items[num_fichier].selected=true then
                inc(taille_fichiers_choisis,entree_fat(contenu_repertoire.Items[num_fichier].data^).taille);

    nb_fichiers_selectionnes.Caption:=inttostr(nb_fichiers_choisis)+textes_disquette[8];
    taille_fichiers_selectionnes.Caption:=inttostr(taille_fichiers_choisis)+textes_disquette[0];
end;

//-------------------------------------------------------------------------------------------
//Acceptation de la rception du drag and drop sur l'arborescence des rpertoires
procedure TMDIChild.dossiersDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
var
    tree:ttreeview;
    list:tlistview;
begin
    accept:=false;
    if source is tlistview then
    begin
        tree:=sender as ttreeview ;
        list:=source as tlistview ;

        if ((tree.parent=list.parent) and (tree.selected<>tree.DropTarget)) or
        (tree.parent<>list.parent) then accept:=true
    end;
end;

//-------------------------------------------------------------------------------------------
//Drag and drop sur l'arborescence des rpertoires
procedure TMDIChild.dossiersDragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
    transfert_de_fichiers(sender,source);
end;

//-------------------------------------------------------------------------------------------
//Transfert de fichier
procedure TMDIChild.transfert_de_fichiers(sender,source:tobject);
var
    tree:ttreeview;
    list:tlistview;
    num_fichier:integer;
    rep_dest:ttreenode;
    fichier1:tfilestream;
    source_disquette:tmdichild;
    num_cluster:integer;
    fichier:entree_fat;
    source_explorer:texplorer;
    nomrep:string;
    buffer_fichier:array of byte;
    resultat_transfert:integer;

begin
    tree:=sender as ttreeview ;
    list:=source as tlistview ;
    rep_dest:=tree.DropTarget;

    resultat_transfert:=1;

    if rep_dest<>nil then
    begin
        //Premier cluster du rpertoire destination
        if rep_dest.Level=0 then num_cluster:=0
            else num_cluster:=entree_fat(rep_dest.data^).premier_cluster;

        if list.SelCount>0 then
        begin
            num_fichier:=list.selected.Index;
            repeat
                resultat_transfert:=1;
                if list.Items[num_fichier].selected=true then
                begin

                    //Extraction du fichier de la disquette source si transfert depuis une image disque
                    if list.Parent is tmdichild then
                    begin
                        source_disquette:=list.parent as tmdichild;
                        fichier.nom:=rep_travail+entree_fat(source_disquette.contenu_repertoire.Items[num_fichier].Data^).nom;
                        fichier.taille:=entree_fat(source_disquette.contenu_repertoire.Items[num_fichier].Data^).taille;
                        fichier.heure :=entree_fat(source_disquette.contenu_repertoire.Items[num_fichier].Data^).heure;
                        fichier.date :=entree_fat(source_disquette.contenu_repertoire.Items[num_fichier].Data^).date;
                        setlength(buffer_fichier,fichier.taille);
                        extraire_fichier(entree_fat(source_disquette.contenu_repertoire.Items[num_fichier].Data^).numero-1,@source_disquette.disquette, buffer_fichier);
                        //Transfert du fichier
                        resultat_transfert:=transfert_fichier(@fichier,buffer_fichier,num_cluster,@disquette);
                    end;

                    //Chargement du fichier depuis le disque si transfert depuis l'explorer
                    if list.Parent is texplorer then
                    begin
                        source_explorer:=list.parent as texplorer;
                        nomrep:=source_explorer.chemin;
                        fichier.nom:=nomrep+list.Items[num_fichier].Caption;
                        fichier.taille:=strtoint(list.Items[num_fichier].SubItems[0]);
                        fichier.heure :=list.Items[num_fichier].SubItems[1];
                        fichier.date :=list.Items[num_fichier].SubItems[2];

                        if fichier.taille<disquette.taille then   //Pr-contrle de la taille du fichier  charger en mmoire
                        begin
                            fichier1:= TFileStream.Create(fichier.nom,fmOpenRead);
                            fichier1.Seek(0,soFromBeginning);
                            setlength(buffer_fichier,fichier.taille);
                            fichier1.read(buffer_fichier[0],fichier.taille);
                            fichier1.Free;
                            //Transfert du fichier
                            resultat_transfert:=transfert_fichier(@fichier,buffer_fichier,num_cluster,@disquette);
                        end else resultat_transfert:=0;
                    end;

                    //Effacement du fichier en mmoire
                    setlength(buffer_fichier,0);

                    disquette.modif:=true;
                end;
            inc(num_fichier);
            until (num_fichier>=list.items.count) or (resultat_transfert=0)
        end;
    end;
    actualisation_repertoires;

    if resultat_transfert=0 then MessageDlg(textes_general[122], mtInformation, [mbOk], 0);
end;

//-------------------------------------------------------------------------------------------
//Cre un nouveau rpertoire
procedure TMDIChild.nouveau_repertoire;
var
    nom_rep:string;
    niveau_rep:integer;
    cluster_rep:integer;
    resultat:integer;

begin
    if dossiers.selected<>nil then
        if InputQuery('',textes_disquette[10],nom_rep) then
        begin
            niveau_rep:=dossiers.Selected.level;
            if niveau_rep=0 then cluster_rep:=0
                else cluster_rep:=entree_fat(dossiers.selected.data^).premier_cluster;
            resultat:=creation_repertoire(nom_rep,niveau_rep,cluster_rep,@disquette);
            if resultat=-1 then MessageDlg(textes_disquette[9], mtInformation, [mbOk], 0);
            disquette.modif:=true;
            actualisation_repertoires;
        end;
end;

//-------------------------------------------------------------------------------------------
//Acceptation de la rception du drag and drop sur la liste des fichiers
procedure TMDIChild.contenu_repertoireDragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var
    sender_list:tlistview;
    source_list:tlistview;
begin
    accept:=false;
    if source is tlistview then
    begin
        source_list:=source as tlistview ;
        sender_list:=sender as tlistview ;
        if (sender_list.parent<>source_list.parent) then accept:=true;
    end;
end;

//-------------------------------------------------------------------------------------------
//Drag and drop sur la liste des fichiers
procedure TMDIChild.contenu_repertoireDragDrop(Sender, Source: TObject; X,
  Y: Integer);
var
    sender_parent:tmdichild;
    sender_list:tlistview;
    sender_tree:ttreeview;

begin
    sender_list:=sender as tlistview;
    sender_parent:=sender_list.parent as tmdichild;
    sender_tree:=sender_parent.dossiers as ttreeview;
    sender_tree.DropTarget:=sender_tree.Selected;
    transfert_de_fichiers(sender_tree,source);
end;

//-------------------------------------------------------------------------------------------
//Effacement du ou des fichiers slectionns
procedure TMDIChild.effacer_fichier;
var
    compteur:integer;
    nombre_fichiers:integer;
    num_fichier:integer;

begin
    try
        if contenu_repertoire.SelCount >0 then
        begin
            nombre_fichiers:=contenu_repertoire.SelCount;
            num_fichier:=contenu_repertoire.Selected.index;
            compteur:=0;
            repeat
                inc(compteur);
                if compteur>1 then
                begin
                    repeat
                        inc(num_fichier);
                    until contenu_repertoire.Items[num_fichier].Selected=true
                end;
                effacement_fichier(entree_fat(contenu_repertoire.Items[num_fichier].Data^).adresse_declaration,@disquette);
            until compteur>=nombre_fichiers;
            disquette.modif:=true;
            contenu_repertoire.ClearSelection;
            actualisation_repertoires;
        end;
    except
    end;
end;

//-------------------------------------------------------------------------------------------
//Effacement du rpertoire slectionn
procedure TMDIChild.effacer_repertoire;
var
    cluster_rep:integer;
    addr_rep:integer;

begin
    try
        if dossiers.Selected.Level>0 then
        begin
            cluster_rep:=entree_fat(dossiers.selected.data^).premier_cluster;
            addr_rep:=entree_fat(dossiers.selected.data^).adresse_declaration;

            effacement_repertoire(cluster_rep,addr_rep,@disquette);
            disquette.modif:=true;
            dossiers.Items.Item[0].Selected:=true;
            actualisation_repertoires;
        end;
    except
    end;
end;

//-------------------------------------------------------------------------------------------
//Suppression de rpertoire par la touche 'Suppr'
procedure TMDIChild.dossiersKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    if key=VK_DELETE then effacer_repertoire;
end;

//-------------------------------------------------------------------------------------------
//Affichage du menu pop-up sur l'arborescence des rpertoires
procedure TMDIChild.dossiersMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
    selection:ttreenode;

begin
    if Button = mbRight then
    begin
        selection:=dossiers.GetNodeAt(x, y);
        if selection<>nil then
            if selection.Level>0 then
            begin
                selection.Selected:=true;
                Popupmenu_repertoires.Popup(mouse.cursorpos.x,mouse.cursorpos.y);
            end;
    end;
end;

//-------------------------------------------------------------------------------------------
//Exploration du contenu d'une image disque 'ST'
procedure TMDIChild.lire_contenu_img(pointeur:integer; niveau_rep:integer; image:p_imagedisk);
var
    pointeurrep:integer;
    index:integer;
    i:integer;
    entree_fat:integer;
    cluster_suivant:integer;
    data:byte;
    fin_repertoire:boolean;
    nom:string;
    extension:string;
    nomfichier:string;
    nb_max_entrees:integer;
    erreur_pointeur:boolean;

    taille_entree:integer;
    heure_modification_entree:string;
    date_modification_entree:string;
    premier_cluster_entree:integer;
    temp:integer;
    temp_heure_date:string;

begin
    // Calcul du nombre maxi d'entres FAT possibles -
    // *1.2 par scurit
    nb_max_entrees:=trunc((length(image^.donnees)/image^.taille_cluster)*1.2);

    index:=0;
    entree_fat:=0;
    fin_repertoire:=false;
    erreur_pointeur:=false;
    try begin
        while (not fin_repertoire) and (not erreur_pointeur) and (not erreur_fat) do
        begin
            if (image^.donnees[pointeur+index]<>$e5) and (image^.donnees[pointeur+index]<>0) then   //Pas entre efface
            begin
                //Lecture du nom de l'entre
                i:=0;
                nom:='';
                extension:='';
                while (image^.donnees[pointeur+index+i]<>32) and (i<8) do  //Lecture des 8 premiers caractres
                begin
                    data:=image^.donnees[pointeur+index+i];
                    if (i=0) and (data=$5) then data:=$e5;
                    nom:=nom+char(data);
                    inc(i);
                end;

                i:=8;
                while (image^.donnees[pointeur+index+i]<>32) and (i<11) do  //Lecture de l'extension
                begin
                    extension:=extension+char(image^.donnees[pointeur+index+i]);
                    inc(i);
                end;
                nomfichier:=nom;
                if extension<>'' then nomfichier:=nomfichier+'.'+extension;

                data:=image^.donnees[pointeur+index+11];

                //Vrification si entre = nom de la disquette
                if (data and 8)=8 then image^.nomimage :=nomfichier;

                // Si l'entre est un fichier ou un rpertoire, on continue
                if (nomfichier<>'.') and (nomfichier<>'..') and ((data and 8)<>8) then
                begin
                    inc(image^.nb_entrees_fat);
                    if image^.nb_entrees_fat>nb_max_entrees then abort;

                    setlength(image^.contenu_img,image^.nb_entrees_fat);

                    //Dtermine si fichier ou rpertoire
                    if (data and $10)<>$10 then image^.contenu_img[image^.nb_entrees_fat-1].sorte:='file'
                        else image^.contenu_img[image^.nb_entrees_fat-1].sorte:='dir';

                    // Numro de l'entre
                    image^.contenu_img[image^.nb_entrees_fat-1].numero:=image^.nb_entrees_fat;

                    // Numro de l'entre du rpertoire parent
                    image^.contenu_img[image^.nb_entrees_fat-1].parent:=niveau_rep;

                    // Lecture des attributs de l'entre
                    image^.contenu_img[image^.nb_entrees_fat-1].attributs:=data;

                    //Lecture de l'heure de la modification de l'entre

                    temp:=image^.donnees[pointeur+index+22];
                    temp:=temp+(image^.donnees[pointeur+index+23] shl 8);
                    temp_heure_date:=format('%.2d',[temp shr 11]);
                    heure_modification_entree:=temp_heure_date+':';
                    temp_heure_date:=format('%.2d',[(temp and $7e0) shr 5]);
                    heure_modification_entree:=heure_modification_entree+temp_heure_date+':';
                    temp_heure_date:=format('%.2d',[(temp and $1f)*2]);
                    heure_modification_entree:=heure_modification_entree+temp_heure_date;
                    image^.contenu_img[image^.nb_entrees_fat-1].heure:=heure_modification_entree;

                    //Lecture de la date de modification de l'entre
                    temp:=image^.donnees[pointeur+index+24];
                    temp:=temp+(image^.donnees[pointeur+index+25] shl 8);
                    temp_heure_date:=format('%.2d',[temp and $1f]);
                    date_modification_entree:=temp_heure_date+'/';
                    temp_heure_date:=format('%.2d',[(temp and $1e0) shr 5]);
                    date_modification_entree:=date_modification_entree+temp_heure_date+'/';
                    temp_heure_date:=format('%.4d',[(temp shr 9)+1980]);
                    date_modification_entree:=date_modification_entree+temp_heure_date;
                    image^.contenu_img[image^.nb_entrees_fat-1].date:=date_modification_entree;

                    //Lecture du numro du premier cluster de l'entre
                    temp:=image^.donnees[pointeur+index+26];
                    temp:=temp+(image^.donnees[pointeur+index+27] shl 8);
                    premier_cluster_entree:=temp;
                    image^.contenu_img[image^.nb_entrees_fat-1].premier_cluster:=premier_cluster_entree;

                    //Lecture de la taille de l'entre
                    temp:=image^.donnees[pointeur+index+28];
                    temp:=temp+(image^.donnees[pointeur+index+29] shl 8);
                    temp:=temp+(image^.donnees[pointeur+index+30] shl 16);
                    temp:=temp+(image^.donnees[pointeur+index+31] shl 24);
                    taille_entree:=temp;
                    image^.contenu_img[image^.nb_entrees_fat-1].taille:=taille_entree;

                    //Adresse d'enregistrement de l'entre
                    image^.contenu_img[image^.nb_entrees_fat-1].adresse_declaration:=pointeur+index;

                    //Nom de l'entre
                    image^.contenu_img[image^.nb_entrees_fat-1].nom:=nomfichier;

                    // Chemin d'accs  l'entre
                    if niveau_rep=0 then image^.contenu_img[image^.nb_entrees_fat-1].chemin:=''
                        else image^.contenu_img[image^.nb_entrees_fat-1].chemin:=image^.contenu_img[niveau_rep-1].chemin+image^.contenu_img[niveau_rep-1].nom+'\'; 

                    if image^.contenu_img[image^.nb_entrees_fat-1].sorte='dir' then
                    begin
                        pointeurrep:=(premier_cluster_entree-2)*image^.taille_cluster;
                        pointeurrep:=pointeurrep+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
                        if pointeurrep>length(image^.donnees) then erreur_pointeur:=true
                            else lire_contenu_img(pointeurrep,image^.contenu_img[image^.nb_entrees_fat-1].numero,image);
                    end;
                end;
                if nomfichier='.' then
                begin
                    entree_fat:=image^.donnees[pointeur+index+26];
                    entree_fat:=entree_fat+(image^.donnees[pointeur+index+27] shl 8);
                end;
            end;

            inc(index,32);  //Entre suivante dans rpertoire

            if niveau_rep<>0 then
            //Si pas rpertoire principal recherche cluster suivant
            begin
                if index>=image^.taille_cluster then
                begin
                    cluster_suivant:=lire_etat_cluster(entree_fat,image);
                    if (cluster_suivant>=2) and (cluster_suivant<=4080) then
                    begin
                        entree_fat:=cluster_suivant;
                        pointeur:=(cluster_suivant-2)*image^.taille_cluster;
                        pointeur:=pointeur+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
                        if pointeur>length(image^.donnees) then erreur_pointeur:=true;
                        index:=0;
                    end
                    else fin_repertoire:=true;
                end
                else
                    if image^.donnees[pointeur+index]=0 then fin_repertoire:=true;
                end
            else
            //Si rpertoire principal, continue jusqu' atteindre le nombre d'entres maxi
                if (index>=image^.entrees_rep_principal shl 5) or (image^.donnees[pointeur+index]=0) then fin_repertoire:=true;
            end;
        end
    except
        MessageDlg(textes_disquette[13], mtInformation, [mbOk], 0);
        setlength(image^.contenu_img,0);
        erreur_fat:=true;
    end;
end;

end.

